<?php

namespace App\Exports\SuperAdmin;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class TherapistCommunityCategoriesExport implements FromArray, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    protected $therapist_community_categories;
    public function __construct($therapist_community_categories)
    {
        $this->therapist_community_categories = $therapist_community_categories;
    }
    public function array(): array
    {
        $data = [];
        foreach ($this->therapist_community_categories as $therapist_community_category) {
            $single = [$therapist_community_category->id, $therapist_community_category->name, $therapist_community_category->description, $therapist_community_category->is_active, $therapist_community_category->slug, date_format($therapist_community_category->created_at, 'd-m-Y')];
            $data[] = $single;
        }
        return $data;
    }
    public function headings(): array
    {
        return ["id", "name", "description", "is_active", "slug", "created_at"];
    }
}
